<?php
/**
 * Exchange Resets
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

echo '<h2>Exchange Resets Packages</h2>';

// load configs
$pluginConfig = file_get_contents(__PATH_EXCHANGERESETS_ROOT__.'config.json');
if(!$pluginConfig) throw new Exception('Error loading config file.');
$pluginConfig = json_decode($pluginConfig, true);
if(!is_array($pluginConfig)) throw new Exception('Error loading config file.');

// remove package
if(check_value($_GET['delete'])) {
	try {
		
		if(!Validator::UnsignedNumber($_GET['delete'])) throw new Exception('The provided package is not valid.');
		if(!array_key_exists($_GET['delete'], $pluginConfig['exchange_list'])) throw new Exception('The provided package is not valid.');
		unset($pluginConfig['exchange_list'][$_GET['delete']]);
		if(count($pluginConfig['exchange_list']) < 1) {
			unset($pluginConfig['exchange_list']);
		}
		
		$cfgFile = __PATH_EXCHANGERESETS_ROOT__.'config.json';
		if(!is_writable($cfgFile)) throw new Exception('The configuration file is not writable.');
		$fp = fopen($cfgFile, 'w');
		if(!fwrite($fp, json_encode($pluginConfig))) throw new Exception('There has been an error while saving changes.');
		fclose($fp);
		
		header('Location: ' . admincp_base('exchangeresets&page=packages'));
		
	} catch(Exception $ex) {
		message('error', $ex->getMessage());
	}
}

// add package
if(check_value($_POST['package_submit'])) {
	try {
		
		if(!check_value($_POST['package_resets'])) throw new Exception('The value submitted for the package resets is not valid.');
		if(!check_value($_POST['package_credits'])) throw new Exception('The value submitted for the package credits reward is not valid.');
		
		if(!Validator::UnsignedNumber($_POST['package_resets'])) throw new Exception('The value submitted for the package resets is not valid.');
		if(!Validator::UnsignedNumber($_POST['package_credits'])) throw new Exception('The value submitted for the package credits reward is not valid.');
		
		if(is_array($_POST['package_resets'])) {
			if(array_key_exists($_POST['package_resets'], $pluginConfig['exchange_list'])) throw new Exception('Another package with the same amount of resets already exists.');
			if(in_array($_POST['package_credits'], $pluginConfig['exchange_list'])) throw new Exception('Another package with the same amount of credits reward already exists.');
		}
		
		$pluginConfig['exchange_list'][$_POST['package_resets']] = $_POST['package_credits'];
		ksort($pluginConfig['exchange_list']);
		
		$cfgFile = __PATH_EXCHANGERESETS_ROOT__.'config.json';
		if(!is_writable($cfgFile)) throw new Exception('The configuration file is not writable.');
		$fp = fopen($cfgFile, 'w');
		if(!fwrite($fp, json_encode($pluginConfig))) throw new Exception('There has been an error while saving changes.');
		fclose($fp);
		
		header('Location: ' . admincp_base('exchangeresets&page=packages'));
		
	} catch(Exception $ex) {
		message('error', $ex->getMessage());
	}
}

echo '<div class="row">';
	
	// new package
	echo '<div class="col-xs-12 col-md-4">';
		echo '<div class="panel panel-primary">';
		echo '<div class="panel-heading">New Exchange Package</div>';
		echo '<div class="panel-body">';

			echo '<form role="form" action="'.admincp_base('exchangeresets&page=packages').'" method="post">';
				echo '<div class="form-group">';
					echo '<label for="input_1">Resets:</label>';
					echo '<input type="text" class="form-control" id="input_1" name="package_resets"/>';
				echo '</div>';
				echo '<div class="form-group">';
					echo '<label for="input_2">Credits Reward:</label>';
					echo '<input type="text" class="form-control" id="input_2" name="package_credits"/>';
				echo '</div>';

				echo '<button type="submit" name="package_submit" value="1" class="btn btn-primary">Add New Exchange Package</button>';
			echo '</form>';

		echo '</div>';
		echo '</div>';
	echo '</div>';
	
	// package list
	echo '<div class="col-xs-12 col-md-8">';
		echo '<div class="panel panel-default">';
		echo '<div class="panel-heading">Exchange Packages</div>';
		echo '<div class="panel-body">';
			if(is_array($pluginConfig['exchange_list'])) {
				echo '<table class="table table-hover table-striped">';
					echo '<thead>';
						echo '<tr>';
							echo '<th>Resets</th>';
							echo '<th>Credits Reward</th>';
							echo '<th></th>';
						echo '</tr>';
					echo '</thead>';
					echo '<tbody>';
					foreach($pluginConfig['exchange_list'] as $resets => $creditReward) {
						echo '<tr>';
							echo '<td>'.number_format($resets).'</td>';
							echo '<td>'.number_format($creditReward).'</td>';
							echo '<td><a href="'.admincp_base('exchangeresets&page=packages&delete='.$resets).'" class="btn btn-xs btn-danger">Remove</a></td>';
						echo '</tr>';
					}
					echo '</tbody>';
				echo '</table>';
			} else {
				message('warning', 'There are no exchange packages.');
			}
		echo '</div>';
		echo '</div>';
	echo '</div>';
echo '</div>';